#!/usr/bin/env python
# Add Reports to Project

# Copyright 2004 by Brian C. Christensen

#    This file is part of GanttPV.
#
#    GanttPV is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    GanttPV is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with GanttPV; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

# 041224 - added logic to insert new reports and columns
# 041225 - fixed some minor bugs; replaced standard report examples
# 041226 - make add of resource reports conditional

def DoIt(self):

    dp = Data.Database['Project']
    dr = Data.Database['Report']
    drc = Data.Database['ReportColumn']
    drt = Data.Database['ReportType']
    dct = Data.Database['ColumnType']

    # build indices for report type and column type names
    rtindex = {}
    for k, v in drt.iteritems():
        name = v.get('Name')
        if name:
            rtindex[name] = k

    if debug: print "rtindex", rtindex

    ctindex = {}
    for k, v in dct.iteritems():
        name = v.get('Name')
        rtid = v.get('ReportTypeID')
        if name and rtid and drt.has_key(rtid):
            rname = drt[rtid].get('Name')
            if rname:
                key = ( rname, name )
                ctindex[key] = k

    if debug: print "ctindex", ctindex

    def DoReport(projectid, change):
        rtname = change.get('ReportTypeID')    
        rtid = rtindex.get(rtname)
        if not rtid: return 0
        change['ReportTypeID'] = rtid
        if change.get('SelectColumn') == "ProjectID":
            change['SelectValue'] = projectid
        change['ProjectID'] = projectid
        change['Table'] = 'Report'
        undo = Data.Update(change)
        return undo['ID']

    def DoColumn(reportid, change):
        ctkey = change.get('ColumnTypeID')    
        ctid = ctindex.get(ctkey)
        if not ctid: return 0
        change['ColumnTypeID'] = ctid
        change['ReportID'] = reportid
        change['Table'] = 'ReportColumn'
        undo = Data.Update(change)
        return undo['ID']

    def AddReport(project, report, columns):
        reportid = DoReport(project, report)
        if reportid:
            rlist = [ reportid for x in columns ] 
            clist = filter( None, map( DoColumn, rlist, columns ) )
            Data.ReorderReportColumns(reportid, clist)

    # get the definition of the currently selected report row
    # use the report's cross reference 'row' to translates the 'item #' into 'row id #'
    reportrowid = self.Report.rows[self.Report.currentItem]  # item -> report row id
    rr = self.Report.reportrow[reportrowid]  # report row id -> report row record

    # make sure that a project row is selected
    rowtable = rr['TableName']
    projectid = rr['TableID']
    if rowtable != 'Project': 
        if debug: print "rowtable not project", rowtable
        return
    if not projectid or not dp.has_key(projectid) or dp[projectid].get('zzStatus') == 'deleted': 
        if debug: print "project id not valid", rowid
        return

# -------- replace this section with your prefered report definitions --------
    if projectid == 1:
        if ctindex.has_key(('Resource', 'Email'),):
            report = { 'Name':  "Resource List", 'ReportTypeID':  'Resource' , }
            columns = [
            {'ColumnTypeID':  ('Resource', 'ID') , 'Width':  40 , },
            {'ColumnTypeID':  ('Resource', 'Project/Name') , 'Width':  67 , },
            {'ColumnTypeID':  ('Resource', 'Category') , 'Width':  60 , },
            {'ColumnTypeID':  ('Resource', 'Name') , 'Label':  "Name", 'Width':  122 , 'Periods':  0 , },
            {'ColumnTypeID':  ('Resource', 'FirstName') , 'Width':  50 , },
            {'ColumnTypeID':  ('Resource', 'Phonetic') , 'Width':  59 , },
            {'ColumnTypeID':  ('Resource', 'WorkPhone') , 'Width':  87 , },
            {'ColumnTypeID':  ('Resource', 'CellPhone') , 'Width':  84 , },
            {'ColumnTypeID':  ('Resource', 'Email') , 'Width':  174 , },
            {'ColumnTypeID':  ('Resource', 'Skills') , 'Width':  60 , },
            {'ColumnTypeID':  ('Resource', 'Title') , 'Width':  110 , },
            {'ColumnTypeID':  ('Resource', 'Location') , 'Width':  60 , },
            {'Width':  50 , 'ColumnTypeID':  ('Resource', 'Notes') , },
            ]
            AddReport(projectid, report, columns)

        report = { 'Name':  "Project", 'ReportTypeID':  'Project' , }
        columns = [
        {'ColumnTypeID':  ('Project', 'ID') , },
        {'ColumnTypeID':  ('Project', 'Name') , 'Width':  140 , },
        {'ColumnTypeID':  ('Project', 'StartDate') , 'Width':  80 , },
        {'Width':  80 , 'ColumnTypeID':  ('Project', 'TargetEndDate') , },
        ]
        AddReport(projectid, report, columns)

        report = { 'Name':  "FollowUp", 'ReportTypeID':  'FollowUp' , 'ShowHidden':  False , }
        columns = [
        {'ColumnTypeID':  ('FollowUp', 'Project/Name') , 'Width':  72 , },
        {'ColumnTypeID':  ('FollowUp', 'Priority') , 'Width':  51 , },
        {'ColumnTypeID':  ('FollowUp', 'Category') , 'Width':  60 , },
        {'ColumnTypeID':  ('FollowUp', 'Who') , 'Width':  60 , },
        {'ColumnTypeID':  ('FollowUp', 'Description') , 'Width':  226 , },
        {'ColumnTypeID':  ('FollowUp', 'DateAdded') , 'Width':  77 , },
        {'ColumnTypeID':  ('FollowUp', 'Resolution') , 'Width':  133 , },
        {'ColumnTypeID':  ('FollowUp', 'DateResolved') , 'Width':  78 , },
        {'Width':  115 , 'ColumnTypeID':  ('FollowUp', 'Reference') , },
        ]
        AddReport(projectid, report, columns)

        report = { 'Name':  "Measurement", 'ReportTypeID':  'Measurement' , 'ShowHidden':  False , }
        columns = [
        {'ColumnTypeID':  ('Measurement', 'ID') , 'Width':  40 , },
        {'ColumnTypeID':  ('Measurement', 'Name') , 'Width':  140 , },
        {'ColumnTypeID':  ('Measurement', 'Label') , 'Width':  160 , },
        {'ColumnTypeID':  ('Measurement', 'Script') , 'Width':  140 , },
        {'Width':  60 , 'ColumnTypeID':  ('Measurement', 'DataType') , },
        ]
        AddReport(projectid, report, columns)

        report = { 'Name':  "Resource/Assignment", 'ReportTypeID':  'Resource/Assignment' , 'ShowHidden':  False , }
        columns = [
        {'ColumnTypeID':  ('Task', 'Name') , 'Width':  90 , },
        {'ColumnTypeID':  ('Resource/Assignment', 'Task/ProjectID') , 'Width':  50 , },
        {'ColumnTypeID':  ('Resource/Assignment', 'Task/Name') , 'Width':  161 , },
        {'ColumnTypeID':  ('Resource/Assignment', 'EffortHours') , 'Width':  70 , },
        {'ColumnTypeID':  ('Resource/Assignment', 'Week/EffortHours') , 'Periods':  16 , },
        ]
        AddReport(projectid, report, columns)
    else:
   
        report = { 'SelectColumn':  "ProjectID", 'ShowHidden':  True , 'Name':  "Task (Gantt Chart)" , 'SelectValue':  3 , 'ReportTypeID':  'Task' , }
        columns = [
        {'ColumnTypeID':  ('Task', 'Name') , 'Width':  158 , },
        {'ColumnTypeID':  ('Task', 'StartDate') , 'Width':  75 , },
        {'ColumnTypeID':  ('Task', 'DurationHours') , 'Width':  65 , },
        {'ColumnTypeID':  ('Task', 'EffortHours') , 'Width':  59 , },
        {'ColumnTypeID':  ('Task', 'ActualEndDate') , 'Width':  75 , },
        {'ColumnTypeID':  ('Task', 'CalculatedStartDate') , 'Width':  80 , },
        {'ColumnTypeID':  ('Task', 'CalculatedEndDate') , 'Width':  80 , },
        {'ColumnTypeID':  ('Task', 'Week/Gantt') , 'Periods':  16 , },
        {'ColumnTypeID':  ('Task', ' ') , 'Width':  15 , },
        {'ColumnTypeID':  ('Task', 'Day/Gantt') , 'Periods':  14 , },
        ]
        AddReport(projectid, report, columns)

        report = { 'SelectColumn':  "ProjectID", 'Name':  "Task/Checklist" , 'SelectValue':  3 , 'ReportTypeID':  'Task/Checklist' , }
        columns = [
        {'ColumnTypeID':  ('Task', 'StartDate') , 'Width':  80 , },
        {'ColumnTypeID':  ('Task', 'EffortHours') , 'Width':  50 , },
        {'ColumnTypeID':  ('Task', 'DurationHours') , 'Width':  57 , },
        {'ColumnTypeID':  ('Task', 'Name') , 'Width':  164 , },
        {'ColumnTypeID':  ('Task/Checklist', 'Name') , 'Width':  238 , },
        {'ColumnTypeID':  ('Task/Checklist', 'EffortHours') , 'Width':  63 , },
        {'ColumnTypeID':  ('Task/Checklist', 'Notes') , 'Width':  115 , },
        {'ColumnTypeID':  ('Task/Checklist', 'ActualEndDate') , 'Width':  80 , },
        ]
        AddReport(projectid, report, columns)

        report = { 'Name':  "FollowUp", 'SelectValue':  3 , 'SelectColumn':  "ProjectID", 'ReportTypeID':  'FollowUp' , 'ShowHidden':  False , }
        columns = [
        {'ColumnTypeID':  ('FollowUp', 'Priority') , 'Width':  55 , },
        {'ColumnTypeID':  ('FollowUp', 'Category') , 'Width':  60 , },
        {'ColumnTypeID':  ('FollowUp', 'Who') , 'Width':  60 , },
        {'ColumnTypeID':  ('FollowUp', 'Description') , 'Width':  194 , },
        {'ColumnTypeID':  ('FollowUp', 'DateAdded') , 'Width':  68 , },
        {'ColumnTypeID':  ('FollowUp', 'Resolution') , 'Width':  160 , },
        {'ColumnTypeID':  ('FollowUp', 'DateResolved') , 'Width':  72 , },
        {'Width':  111 , 'ColumnTypeID':  ('FollowUp', 'Reference') , },
        ]
        AddReport(projectid, report, columns)

        report = { 'Name':  "Expense", 'SelectValue':  3 , 'SelectColumn':  "ProjectID", 'ReportTypeID':  'Expense' , }
        columns = [
        {'ColumnTypeID':  ('Expense', 'Category') , 'Width':  60 , },
        {'ColumnTypeID':  ('Expense', 'Description') , 'Width':  180 , },
        {'ColumnTypeID':  ('Expense', 'PlannedDate') , 'Width':  80 , },
        {'ColumnTypeID':  ('Expense', 'PlannedAmount') , 'Width':  80 , },
        {'ColumnTypeID':  ('Expense', 'ActualDate') , 'Width':  80 , },
        {'ColumnTypeID':  ('Expense', 'ActualAmount') , 'Width':  80 , },
        {'ColumnTypeID':  ('Expense', 'Note') , 'Width':  140 , },
        {'Width':  140 , 'ColumnTypeID':  ('Expense', 'Reference') , },
        ]
        AddReport(projectid, report, columns)

        if ctindex.has_key(('Resource', 'Email'),):
            report = { 'Name':  "Resource", 'SelectValue':  3 , 'SelectColumn':  "ProjectID", 'ReportTypeID':  'Resource' , }
            columns = [
            {'ColumnTypeID':  ('Resource', 'ID') , 'Width':  40 , },
            {'ColumnTypeID':  ('Resource', 'Category') , 'Width':  60 , },
            {'ColumnTypeID':  ('Resource', 'Name') , 'Width':  72 , },
            {'ColumnTypeID':  ('Resource', 'FirstName') , 'Width':  59 , },
            {'ColumnTypeID':  ('Resource', 'Title') , 'Width':  110 , },
            {'ColumnTypeID':  ('Resource', 'Phonetic') , 'Width':  60 , },
            {'ColumnTypeID':  ('Resource', 'WorkPhone') , 'Width':  106 , },
            {'ColumnTypeID':  ('Resource', 'CellPhone') , 'Width':  80 , },
            {'ColumnTypeID':  ('Resource', 'Email') , 'Width':  160 , },
            {'ColumnTypeID':  ('Resource', 'Location') , 'Width':  60 , },
            {'Width':  50 , 'ColumnTypeID':  ('Resource', 'Notes') , },
            ]
            AddReport(projectid, report, columns)

        report = { 'SelectColumn':  "ProjectID", 'Name':  "ProjectMeasurement", 'SelectValue':  3 , 'ReportTypeID':  'ProjectMeasurement' , }
        columns = [
        {'ColumnTypeID':  ('ProjectMeasurement', 'MeasurementID') , 'Width':  103 , },
        {'ColumnTypeID':  ('ProjectMeasurement', 'Measurement/Label') , 'Width':  167 , },
        {'ColumnTypeID':  ('ProjectMeasurement', 'LastWeekly') , 'Width':  80 , },
        {'ColumnTypeID':  ('ProjectMeasurement', 'Week/Measurement') , 'Periods':  18 , },
        ]
        AddReport(projectid, report, columns)

        report = { 'SelectColumn':  "ProjectID", 'Name':  "ProjectResource", 'SelectValue':  3 , 'ReportTypeID':  'ProjectResource' , }
        columns = [
        {'ColumnTypeID':  ('ProjectResource', 'ResourceID') , 'Width':  72 , },
        {'ColumnTypeID':  ('ProjectResource', 'Resource/Name') , 'Width':  140 , },
        {'ColumnTypeID':  ('ProjectResource', 'HourlyRate') , 'Width':  71 , },
        {'ColumnTypeID':  ('ProjectResource', 'Week/ActualEffortHours') , 'Periods':  14 , },
        ]
        AddReport(projectid, report, columns)

        report = { 'Name':  "Task/Assignment", 'SelectValue':  3 , 'SelectColumn':  "ProjectID", 'ReportTypeID':  'Task/Assignment' , }
        columns = [
        {'ColumnTypeID':  ('Task', 'CalculatedStartDate') , 'Width':  80 , },
        {'ColumnTypeID':  ('Task', 'CalculatedEndDate') , 'Width':  80 , },
        {'ColumnTypeID':  ('Task', 'EffortHours') , 'Width':  80 , },
        {'ColumnTypeID':  ('Task', 'Name') , 'Width':  140 , },
        {'ColumnTypeID':  ('Task/Assignment', 'Resource/Name') , 'Width':  140 , },
        {'ColumnTypeID':  ('Task/Assignment', 'EffortHours') , 'Width':  80 , },
        {'ColumnTypeID':  ('Task/Assignment', 'Week/EffortHours') , 'Periods':  16 , },
        ]
        AddReport(projectid, report, columns)
 
# -------- End of report definition section --------

    Data.SetUndo('Add Reports')
    if debug: print "End add reports"

DoIt(self)
